/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.AccountManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;

public class EPersonAdminServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(EPersonAdminServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showMain(context, request, response);
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_add")) {
            EPerson e = EPerson.create((Context)context);
            e.setEmail("newuser" + e.getID());
            e.update();
            request.setAttribute("eperson", (Object)e);
            JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
            context.complete();
        } else if (button.equals("submit_edit")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)Boolean.TRUE);
                this.showMain(context, request, response);
            } else {
                Group[] groupMemberships = Group.allMemberGroups((Context)context, (EPerson)e);
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("group.memberships", (Object)groupMemberships);
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
                context.complete();
            }
        } else if (button.equals("submit_save") || button.equals("submit_resetpassword")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            String oldEmail = e.getEmail();
            String newEmail = request.getParameter("email").trim();
            String netid = request.getParameter("netid");
            if (!newEmail.equals(oldEmail)) {
                if (EPerson.findByEmail((Context)context, (String)newEmail) == null) {
                    e.setEmail(newEmail);
                    e.setFirstName(request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                    e.setLastName(request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                    if (netid != null) {
                        e.setNetid(netid.equals("") ? null : netid.toLowerCase());
                    } else {
                        e.setNetid(null);
                    }
                    e.setMetadata("phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                    e.setMetadata("language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                    e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                    e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                    e.update();
                    if (button.equals("submit_resetpassword")) {
                        try {
                            this.resetPassword(context, request, response, e);
                        }
                        catch (MessagingException e1) {
                            JSPManager.showJSP(request, response, "/dspace-admin/eperson-resetpassword-error.jsp");
                            return;
                        }
                    }
                    this.showMain(context, request, response);
                    context.complete();
                } else {
                    request.setAttribute("eperson", (Object)e);
                    request.setAttribute("email_exists", (Object)Boolean.TRUE);
                    JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
                    context.complete();
                }
            } else {
                if (netid != null) {
                    e.setNetid(netid.equals("") ? null : netid.toLowerCase());
                } else {
                    e.setNetid(null);
                }
                e.setFirstName(request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                e.setLastName(request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                e.setMetadata("phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                e.setMetadata("language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                e.update();
                if (button.equals("submit_resetpassword")) {
                    try {
                        this.resetPassword(context, request, response, e);
                    }
                    catch (MessagingException e1) {
                        JSPManager.showJSP(request, response, "/dspace-admin/eperson-resetpassword-error.jsp");
                        return;
                    }
                }
                this.showMain(context, request, response);
                context.complete();
            }
        } else if (button.equals("submit_delete")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)Boolean.TRUE);
                this.showMain(context, request, response);
            } else {
                request.setAttribute("eperson", (Object)e);
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-confirm-delete.jsp");
            }
        } else if (button.equals("submit_confirm_delete")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            try {
                e.delete();
            }
            catch (EPersonDeletionException ex) {
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("tableList", (Object)ex.getTables());
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-deletion-error.jsp");
            }
            this.showMain(context, request, response);
            context.complete();
        } else if (button.equals("submit_login_as")) {
            if (!ConfigurationManager.getBooleanProperty((String)"webui.user.assumelogin", (boolean)false)) {
                throw new AuthorizeException("Turn on webui.user.assumelogin to activate Login As feature");
            }
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)new Boolean(true));
                this.showMain(context, request, response);
            } else {
                if (!AuthorizeManager.isAdmin((Context)context)) {
                    throw new AuthorizeException("Only site administrators may assume login as another user.");
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"login-as", (String)("current_eperson=" + context.getCurrentUser().getFullName() + ", id=" + context.getCurrentUser().getID() + ", as_eperson=" + e.getFullName() + ", id=" + e.getID())));
                HttpSession session = request.getSession(false);
                Integer authenticatedID = (Integer)session.getAttribute("dspace.current.user.id");
                if (context.getCurrentUser().getID() != authenticatedID.intValue()) {
                    throw new AuthorizeException("Only authenticated users who are administrators may assume the login as another user.");
                }
                Group administrators = Group.find((Context)context, (int)1);
                if (administrators.isMember(e)) {
                    JSPManager.showJSP(request, response, "/dspace-admin/eperson-loginas-error.jsp");
                    return;
                }
                session.setAttribute("dspace.previous.user.id", (Object)authenticatedID);
                Authenticate.loggedIn(context, request, e);
                Locale epersonLocale = I18nUtil.getEPersonLocale((EPerson)context.getCurrentUser());
                context.setCurrentLocale(epersonLocale);
                Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)epersonLocale);
                int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request);
                for (int i = 0; i < groupIDs.length; ++i) {
                    context.setSpecialGroup(groupIDs[i]);
                    log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
                }
                response.sendRedirect(request.getContextPath() + "/mydspace");
            }
        } else {
            this.showMain(context, request, response);
        }
    }

    private void resetPassword(Context context, HttpServletRequest request, HttpServletResponse response, EPerson e) throws SQLException, IOException, AuthorizeException, ServletException, MessagingException {
        AccountManager.sendForgotPasswordInfo((Context)context, (String)e.getEmail());
        request.setAttribute("reset_password", (Object)Boolean.TRUE);
    }

    private void showMain(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/dspace-admin/eperson-main.jsp");
    }
}

