/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.webui.servlet.SubmissionController;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class JSPVerifyStep
extends JSPStep {
    public static final String VERIFY_JSP = "/submit/review.jsp";
    private static Logger log = Logger.getLogger(JSPVerifyStep.class);

    @Override
    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        SubmissionConfig subProcessConfig = subInfo.getSubmissionConfig();
        LinkedHashMap<String, String> reviewData = new LinkedHashMap<String, String>();
        if (subInfo.getProgressBarInfo() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        for (String stepAndPage : subInfo.getProgressBarInfo().keySet()) {
            String[] fields = stepAndPage.split("\\.");
            int stepNum = Integer.parseInt(fields[0]);
            if (stepNum >= SubmissionController.getCurrentStepConfig(request, subInfo).getStepNumber()) continue;
            SubmissionStepConfig s = subProcessConfig.getStep(stepNum);
            try {
                JSPStepManager stepManager = JSPStepManager.loadStep(s);
                String reviewJSP = stepManager.getReviewJSP(context, request, response, subInfo);
                if (reviewJSP == null || reviewJSP.length() <= 0) continue;
                reviewData.put(stepAndPage, reviewJSP);
            }
            catch (Exception e) {
                log.error((Object)("Problem loading Review JSP for step #" + s.getStepNumber() + ".  "), (Throwable)e);
                JSPManager.showIntegrityError(request, response);
                return;
            }
        }
        if (reviewData.isEmpty()) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        request.setAttribute("submission.review", reviewData);
        JSPStepManager.showJSP(request, response, subInfo, VERIFY_JSP);
    }

    @Override
    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
    }

    @Override
    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

