/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class RequestItemManager {
    private static Logger log = Logger.getLogger(RequestItemManager.class);
    TableRow requestitem;

    public static TableRow getRequestbyToken(Context context, String token) throws SQLException {
        TableRow rd = DatabaseManager.findByUnique((Context)context, (String)"requestitem", (String)"token", (Object)token);
        if (rd == null) {
            return null;
        }
        return rd;
    }

    protected static String getNewToken(Context context, int bitstreamId, int itemID, String reqEmail, String reqName, boolean allfiles) throws SQLException {
        TableRow rd = DatabaseManager.create((Context)context, (String)"requestitem");
        rd.setColumn("token", Utils.generateHexKey());
        rd.setColumn("bitstream_id", bitstreamId);
        rd.setColumn("item_id", itemID);
        rd.setColumn("allfiles", allfiles);
        rd.setColumn("request_email", reqEmail);
        rd.setColumn("request_name", reqName);
        rd.setColumnNull("accept_request");
        rd.setColumn("request_date", new Date());
        rd.setColumnNull("decision_date");
        rd.setColumnNull("expires");
        DatabaseManager.update((Context)context, (TableRow)rd);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created requestitem_token " + rd.getIntColumn("requestitem_id") + " with token " + rd.getStringColumn("token") + "\""));
        }
        return rd.getStringColumn("token");
    }

    public static String getLinkTokenEmail(Context context, String bitstreamId, int itemID, String reqEmail, String reqName, boolean allfiles) throws SQLException {
        String base = ConfigurationManager.getProperty((String)"dspace.url");
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append("request-item").append("?step=2").append("&token=").append(RequestItemManager.getNewToken(context, Integer.parseInt(bitstreamId), itemID, reqEmail, reqName, allfiles)).toString();
        return specialLink;
    }

    public static boolean isRestricted(Context context, DSpaceObject o) throws SQLException {
        List policies = AuthorizeManager.getPoliciesActionFilter((Context)context, (DSpaceObject)o, (int)0);
        for (ResourcePolicy rp : policies) {
            if (!rp.isDateValid()) continue;
            return false;
        }
        return true;
    }
}

