/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="isCollectionAdmin", description="It can be used to verify if the current user is admin of any collection in the site")
public class CollectionAdminFeature
implements AuthorizationFeature {
    public static final String NAME = "isCollectionAdmin";
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof SiteRest) {
            if (this.authorizeService.isAdmin(context)) {
                return true;
            }
            return this.authorizeService.isCollectionAdmin(context);
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site"};
    }
}

