/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.MetadataValueDTOConverter;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.content.dto.MetadataValueDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class MetadataValueDTOListConverter
implements Converter<List<MetadataValueDTO>, MetadataRest> {
    @Autowired
    private MetadataValueDTOConverter valueConverter;

    public MetadataRest convert(List<MetadataValueDTO> metadataValueList) {
        HashMap<CallSite, LinkedList<MetadataValueRest>> mapOfLists = new HashMap<CallSite, LinkedList<MetadataValueRest>>();
        for (MetadataValueDTO metadataValue : metadataValueList) {
            LinkedList<MetadataValueRest> list;
            String key = metadataValue.getSchema() + "." + metadataValue.getElement();
            if (StringUtils.isNotBlank((CharSequence)metadataValue.getQualifier())) {
                key = key + "." + metadataValue.getQualifier();
            }
            if ((list = (LinkedList<MetadataValueRest>)mapOfLists.get(key)) == null) {
                list = new LinkedList<MetadataValueRest>();
                mapOfLists.put((CallSite)((Object)key), list);
            }
            list.add(this.valueConverter.convert(metadataValue));
        }
        MetadataRest metadataRest = new MetadataRest();
        SortedMap<String, List<MetadataValueRest>> metadataRestMap = metadataRest.getMap();
        for (Map.Entry entry : mapOfLists.entrySet()) {
            metadataRestMap.put((String)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.toList()));
        }
        return metadataRest;
    }
}

