/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.NotifyServiceInboundPatternRest;
import org.dspace.app.rest.model.NotifyServiceRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="ldn.ldnservices")
public class NotifyServiceRestRepository
extends DSpaceRestRepository<NotifyServiceRest, Integer> {
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private NotifyServiceInboundPatternService inboundPatternService;
    @Autowired
    ResourcePatch<NotifyServiceEntity> resourcePatch;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public NotifyServiceRest findOne(Context context, Integer id) {
        try {
            NotifyServiceEntity notifyServiceEntity = this.notifyService.find(context, id);
            if (notifyServiceEntity == null) {
                throw new ResourceNotFoundException("The notifyService for ID: " + id + " could not be found");
            }
            return (NotifyServiceRest)this.converter.toRest(notifyServiceEntity, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<NotifyServiceRest> findAll(Context context, Pageable pageable) {
        try {
            return this.converter.toRestPage(this.notifyService.findAll(context), pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected NotifyServiceRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        NotifyServiceRest notifyServiceRest;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            notifyServiceRest = (NotifyServiceRest)mapper.readValue((InputStream)input, NotifyServiceRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", e1);
        }
        if (notifyServiceRest.getScore() != null && (notifyServiceRest.getScore().compareTo(BigDecimal.ZERO) == -1 || notifyServiceRest.getScore().compareTo(BigDecimal.ONE) == 1)) {
            throw new UnprocessableEntityException(String.format("Score out of range [0, 1] %s", notifyServiceRest.getScore().setScale(4).toPlainString()));
        }
        if (this.notifyService.findByLdnUrl(context, notifyServiceRest.getLdnUrl()) != null) {
            throw new UnprocessableEntityException(String.format("LDN url already in use %s", notifyServiceRest.getLdnUrl()));
        }
        NotifyServiceEntity notifyServiceEntity = this.notifyService.create(context, notifyServiceRest.getName());
        notifyServiceEntity.setDescription(notifyServiceRest.getDescription());
        notifyServiceEntity.setUrl(notifyServiceRest.getUrl());
        notifyServiceEntity.setLdnUrl(notifyServiceRest.getLdnUrl());
        notifyServiceEntity.setEnabled(notifyServiceRest.isEnabled());
        notifyServiceEntity.setLowerIp(notifyServiceRest.getLowerIp());
        notifyServiceEntity.setUpperIp(notifyServiceRest.getUpperIp());
        if (notifyServiceRest.getNotifyServiceInboundPatterns() != null) {
            this.appendNotifyServiceInboundPatterns(context, notifyServiceEntity, notifyServiceRest.getNotifyServiceInboundPatterns());
        }
        notifyServiceEntity.setScore(notifyServiceRest.getScore());
        this.notifyService.update(context, notifyServiceEntity);
        return (NotifyServiceRest)this.converter.toRest(notifyServiceEntity, this.utils.obtainProjection());
    }

    private void appendNotifyServiceInboundPatterns(Context context, NotifyServiceEntity notifyServiceEntity, List<NotifyServiceInboundPatternRest> inboundPatternRests) throws SQLException {
        ArrayList<NotifyServiceInboundPattern> inboundPatterns = new ArrayList<NotifyServiceInboundPattern>();
        for (NotifyServiceInboundPatternRest inboundPatternRest : inboundPatternRests) {
            NotifyServiceInboundPattern inboundPattern = this.inboundPatternService.create(context, notifyServiceEntity);
            inboundPattern.setPattern(inboundPatternRest.getPattern());
            inboundPattern.setConstraint(inboundPatternRest.getConstraint());
            inboundPattern.setAutomatic(inboundPatternRest.isAutomatic());
            inboundPatterns.add(inboundPattern);
        }
        notifyServiceEntity.setInboundPatterns(inboundPatterns);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws AuthorizeException, SQLException {
        NotifyServiceEntity notifyServiceEntity = this.notifyService.find(context, id);
        if (notifyServiceEntity == null) {
            throw new ResourceNotFoundException("ldn.ldnservice with id: " + id + " not found");
        }
        this.resourcePatch.patch(context, notifyServiceEntity, patch.getOperations());
        this.notifyService.update(context, notifyServiceEntity);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        try {
            NotifyServiceEntity notifyServiceEntity = this.notifyService.find(context, id);
            if (notifyServiceEntity == null) {
                throw new ResourceNotFoundException("ldn.ldnservice with id: " + id + " not found");
            }
            this.notifyService.delete(context, notifyServiceEntity);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byLdnUrl")
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public NotifyServiceRest findByLdnUrl(@Parameter(value="ldnUrl", required=true) String ldnUrl) {
        try {
            NotifyServiceEntity notifyServiceEntity = this.notifyService.findByLdnUrl(this.obtainContext(), ldnUrl);
            if (notifyServiceEntity == null) {
                return null;
            }
            return (NotifyServiceRest)this.converter.toRest(notifyServiceEntity, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byInboundPattern")
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<NotifyServiceRest> findManualServicesByInboundPattern(@Parameter(value="pattern", required=true) String pattern, Pageable pageable) {
        try {
            List notifyServiceEntities = this.notifyService.findManualServicesByInboundPattern(this.obtainContext(), pattern);
            return this.converter.toRestPage(notifyServiceEntities, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<NotifyServiceRest> getDomainClass() {
        return NotifyServiceRest.class;
    }
}

