/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.rest.model.SubmissionCOARNotifyRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.coarnotify.NotifySubmissionConfiguration;
import org.dspace.coarnotify.service.SubmissionNotifyService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissioncoarnotifyconfigs")
public class SubmissionCoarNotifyRestRepository
extends DSpaceRestRepository<SubmissionCOARNotifyRest, String> {
    @Autowired
    protected SubmissionNotifyService submissionCOARNotifyService;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionCOARNotifyRest findOne(Context context, String id) {
        NotifySubmissionConfiguration coarNotifySubmissionConfiguration = this.submissionCOARNotifyService.findOne(id);
        if (coarNotifySubmissionConfiguration == null) {
            throw new ResourceNotFoundException("No COAR Notify Submission Configuration found for ID: " + id);
        }
        return (SubmissionCOARNotifyRest)this.converter.toRest(coarNotifySubmissionConfiguration, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionCOARNotifyRest> findAll(Context context, Pageable pageable) {
        return this.converter.toRestPage(this.submissionCOARNotifyService.findAll(), pageable, this.utils.obtainProjection());
    }

    @Override
    public Class<SubmissionCOARNotifyRest> getDomainClass() {
        return SubmissionCOARNotifyRest.class;
    }
}

