/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.WorkflowItemRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="workflow.workflowitems")
public class WorkflowItemRestRepository
extends DSpaceRestRepository<WorkflowItemRest, Integer> {
    public static final String OPERATION_PATH_SECTIONS = "sections";
    private static final Logger log = LogManager.getLogger();
    @Autowired
    XmlWorkflowItemService wis;
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    SubmissionService submissionService;
    @Autowired
    EPersonServiceImpl epersonService;
    @Autowired
    WorkflowService<XmlWorkflowItem> wfs;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ClaimedTaskService claimedTaskService;
    @Autowired
    protected XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired
    protected XmlWorkflowFactory workflowFactory;
    private SubmissionConfigService submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();

    @Override
    @PreAuthorize(value="hasPermission(#id, 'WORKFLOWITEM', 'READ')")
    public WorkflowItemRest findOne(Context context, Integer id) {
        XmlWorkflowItem witem = null;
        try {
            witem = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (witem == null) {
            return null;
        }
        return (WorkflowItemRest)this.converter.toRest(witem, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkflowItemRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.wis.countAll(context);
            List witems = this.wis.findAll(context, Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException in " + this.getClass() + "#findAll trying to retrieve all workflowitems from db.", e);
        }
    }

    @SearchRestMethod(name="findBySubmitter")
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkflowItemRest> findBySubmitter(@Parameter(value="uuid") UUID submitterID, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            EPerson ep = this.epersonService.find(context, submitterID);
            long total = this.wis.countBySubmitter(context, ep);
            List witems = this.wis.findBySubmitter(context, ep, Integer.valueOf(pageable.getPageNumber()), Integer.valueOf(pageable.getPageSize()));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException in " + this.getClass() + "#findBySubmitter trying to retrieve eperson or their workflowitems from db.", e);
        }
    }

    @Override
    protected WorkflowItemRest createAndReturn(Context context, List<String> stringList) {
        XmlWorkflowItem source;
        if (stringList == null || stringList.isEmpty() || stringList.size() > 1) {
            throw new UnprocessableEntityException("The given URI list could not be properly parsed to one result");
        }
        try {
            source = this.submissionService.createWorkflowItem(context, stringList.get(0));
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (WorkflowException e) {
            throw new UnprocessableEntityException("Invalid workflow action: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException in " + this.getClass() + "#findBySubmitter trying to create a workflow and adding it to db.", e);
        }
        if (source.getItem().isArchived()) {
            return null;
        }
        return (WorkflowItemRest)this.converter.toRest(source, this.utils.obtainProjection());
    }

    @Override
    public Class<WorkflowItemRest> getDomainClass() {
        return WorkflowItemRest.class;
    }

    @Override
    public WorkflowItemRest upload(HttpServletRequest request, String apiCategory, String model, Integer id, MultipartFile file) throws SQLException {
        Context context = this.obtainContext();
        WorkflowItemRest wsi = this.findOne(context, id);
        XmlWorkflowItem source = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        this.checkIfEditMetadataAllowedInCurrentStep(context, source);
        List<ErrorRest> errors = this.submissionService.uploadFileToInprogressSubmission(context, request, wsi, (InProgressSubmission)source, file);
        wsi = (WorkflowItemRest)this.converter.toRest(source, this.utils.obtainProjection());
        if (!errors.isEmpty()) {
            wsi.getErrors().addAll(errors);
        }
        context.commit();
        return wsi;
    }

    @Override
    public void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws SQLException, AuthorizeException {
        List<Operation> operations = patch.getOperations();
        WorkflowItemRest wsi = this.findOne(context, id);
        XmlWorkflowItem source = (XmlWorkflowItem)this.wis.find(context, id.intValue());
        this.checkIfEditMetadataAllowedInCurrentStep(context, source);
        for (Operation op : operations) {
            String[] path = op.getPath().substring(1).split("/", 3);
            if (OPERATION_PATH_SECTIONS.equals(path[0])) {
                String section = path[1];
                this.submissionService.evaluatePatchToInprogressSubmission(context, request, (InProgressSubmission)source, wsi, section, op);
                continue;
            }
            throw new DSpaceBadRequestException("Patch path operation need to starts with 'sections'");
        }
        this.wis.update(context, (InProgressSubmission)source);
    }

    @Override
    protected void delete(Context context, Integer id) {
        XmlWorkflowItem witem = null;
        try {
            witem = (XmlWorkflowItem)this.wis.find(context, id.intValue());
            if (witem == null) {
                throw new ResourceNotFoundException("WorkflowItem ID " + id + " not found");
            }
            this.wfs.abort(context, (WorkflowItem)witem, context.getCurrentUser());
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException in " + this.getClass() + "#delete trying to retrieve or delete a workflowitem from db.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in " + this.getClass() + "#delete trying to delete a workflowitem from db (abort).", e);
        }
    }

    private void checkIfEditMetadataAllowedInCurrentStep(Context context, XmlWorkflowItem xmlWorkflowItem) {
        try {
            ClaimedTask claimedTask = this.claimedTaskService.findByWorkflowIdAndEPerson(context, xmlWorkflowItem, context.getCurrentUser());
            if (claimedTask == null) {
                throw new UnprocessableEntityException("WorkflowItem with id " + xmlWorkflowItem.getID() + " has not been claimed yet.");
            }
            Workflow workflow = this.workflowFactory.getWorkflow(claimedTask.getWorkflowItem().getCollection());
            Step step = workflow.getStep(claimedTask.getStepID());
            WorkflowActionConfig currentActionConfig = step.getActionConfig(claimedTask.getActionID());
            if (!currentActionConfig.getProcessingAction().getOptions().contains("submit_edit_metadata")) {
                throw new UnprocessableEntityException("submit_edit_metadata is not a valid option on this action (" + currentActionConfig.getProcessingAction().getClass() + ").");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException in " + this.getClass() + "#checkIfEditMetadataAllowedInCurrentStep trying to retrieve workflowitem from db by eperson.", e);
        }
        catch (WorkflowConfigurationException e) {
            throw new RuntimeException("WorkflowConfigurationException in " + this.getClass() + "#checkIfEditMetadataAllowedInCurrentStep trying to retrieve workflow configuration from config", e);
        }
    }

    @SearchRestMethod(name="item")
    public WorkflowItemRest findByItemUuid(@Parameter(value="uuid", required=true) UUID itemUuid, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemUuid);
            XmlWorkflowItem xmlWorkflowItem = (XmlWorkflowItem)this.wis.findByItem(context, item);
            if (xmlWorkflowItem == null) {
                return null;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)xmlWorkflowItem.getItem(), 0)) {
                throw new AccessDeniedException("The current user does not have rights to view the WorkflowItem");
            }
            return (WorkflowItemRest)this.converter.toRest(xmlWorkflowItem, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

