/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.stereotype.Component;

@Component
public class EPersonNetidReplaceOperation<R>
extends PatchOperation<R> {
    private static final String OPERATION_PATH_NETID = "/netid";

    @Override
    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            EPerson eperson = (EPerson)object;
            this.checkModelForExistingValue(eperson);
            eperson.setNetid((String)operation.getValue());
            return object;
        }
        throw new DSpaceBadRequestException("EPersonNetidReplaceOperation does not support this operation");
    }

    private void checkModelForExistingValue(EPerson ePerson) {
        if (ePerson.getNetid() == null) {
            throw new DSpaceBadRequestException("Attempting to replace a non-existent value (netID).");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof EPerson && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_NETID);
    }
}

