/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.Operation;
import org.springframework.stereotype.Component;

@Component
public final class NotifyServicePatchUtils {
    public static final String NOTIFY_SERVICE_INBOUND_PATTERNS = "notifyServiceInboundPatterns";
    private ObjectMapper objectMapper = new ObjectMapper();

    private NotifyServicePatchUtils() {
    }

    protected NotifyServiceInboundPattern extractNotifyServiceInboundPatternFromOperation(Operation operation) {
        NotifyServiceInboundPattern inboundPattern = null;
        try {
            if (operation.getValue() != null) {
                if (operation.getValue() instanceof JsonValueEvaluator) {
                    inboundPattern = (NotifyServiceInboundPattern)this.objectMapper.readValue(((JsonValueEvaluator)operation.getValue()).getValueNode().toString(), NotifyServiceInboundPattern.class);
                } else if (operation.getValue() instanceof String) {
                    inboundPattern = (NotifyServiceInboundPattern)this.objectMapper.readValue((String)operation.getValue(), NotifyServiceInboundPattern.class);
                }
            }
        }
        catch (IOException e) {
            throw new DSpaceBadRequestException("IOException: trying to map json from operation.value to NotifyServiceInboundPattern class.", e);
        }
        if (inboundPattern == null) {
            throw new DSpaceBadRequestException("Could not extract NotifyServiceInboundPattern Object from Operation");
        }
        return inboundPattern;
    }

    protected List<NotifyServiceInboundPattern> extractNotifyServiceInboundPatternsFromOperation(Operation operation) {
        List inboundPatterns = null;
        try {
            if (operation.getValue() != null && operation.getValue() instanceof String) {
                inboundPatterns = (List)this.objectMapper.readValue((String)operation.getValue(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, NotifyServiceInboundPattern.class));
            }
        }
        catch (IOException e) {
            throw new DSpaceBadRequestException("IOException: trying to map json from operation.value to List of NotifyServiceInboundPattern class.", e);
        }
        if (inboundPatterns == null) {
            throw new DSpaceBadRequestException("Could not extract list of NotifyServiceInboundPattern Objects from Operation");
        }
        return inboundPatterns;
    }

    protected int extractIndexFromOperation(Operation operation) {
        String number = "";
        Pattern pattern = Pattern.compile("\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(operation.getPath());
        if (matcher.find()) {
            number = matcher.group(1);
        }
        if (StringUtils.isEmpty((CharSequence)number)) {
            throw new DSpaceBadRequestException("path doesn't contain index");
        }
        return Integer.parseInt(number);
    }
}

