/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.DeferredCsrfToken;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DSpaceCsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final CsrfTokenRepository tokenRepository;
    private CsrfTokenRequestHandler requestHandler = new XorCsrfTokenRequestAttributeHandler();

    public DSpaceCsrfAuthenticationStrategy(CsrfTokenRepository tokenRepository) {
        Assert.notNull((Object)tokenRepository, (String)"tokenRepository cannot be null");
        this.tokenRepository = tokenRepository;
    }

    public void setRequestHandler(CsrfTokenRequestHandler requestHandler) {
        Assert.notNull((Object)requestHandler, (String)"requestHandler cannot be null");
        this.requestHandler = requestHandler;
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        boolean containsParameter;
        boolean containsToken;
        CsrfToken token = this.tokenRepository.loadToken(request);
        boolean bl = containsToken = token != null;
        if (containsToken && (containsParameter = StringUtils.hasLength((String)request.getParameter(token.getParameterName())))) {
            this.resetCSRFToken(request, response);
        }
    }

    public void resetCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        this.tokenRepository.saveToken(null, request, response);
        DeferredCsrfToken deferredCsrfToken = this.tokenRepository.loadDeferredToken(request, response);
        this.requestHandler.handle(request, response, () -> ((DeferredCsrfToken)deferredCsrfToken).get());
        deferredCsrfToken.get();
        this.logger.debug((Object)"Replaced CSRF Token");
    }
}

