/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private RequestService requestService;
    @Autowired
    private SubscribeService subscribeService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission) && !DSpaceRestPermission.WRITE.equals((Object)restPermission) && !DSpaceRestPermission.DELETE.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"subscription")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
        try {
            EPerson currentUser = context.getCurrentUser();
            if (Objects.isNull(currentUser)) {
                return false;
            }
            if (this.authorizeService.isAdmin(context, currentUser)) {
                return true;
            }
            Subscription subscription = this.subscribeService.findById(context, Integer.parseInt(targetId.toString()));
            return Objects.nonNull(subscription) ? currentUser.equals((Object)subscription.getEPerson()) : false;
        }
        catch (SQLException e) {
            log.error(e::getMessage, (Throwable)e);
            return false;
        }
    }
}

