/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.converter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.signposting.model.LinksetNode;

public class LinksetRestMessageConverter {
    private LinksetRestMessageConverter() {
    }

    public static String convert(List<List<LinksetNode>> linksetNodes) {
        StringBuilder responseBody = new StringBuilder();
        linksetNodes.stream().flatMap(Collection::stream).forEach(linksetNode -> {
            if (StringUtils.isNotBlank((String)linksetNode.getLink())) {
                responseBody.append(String.format("<%s> ", linksetNode.getLink()));
            }
            if (Objects.nonNull((Object)linksetNode.getRelation())) {
                responseBody.append(String.format("; rel=\"%s\" ", linksetNode.getRelation().getName()));
            }
            if (StringUtils.isNotBlank((String)linksetNode.getType())) {
                responseBody.append(String.format("; type=\"%s\" ", linksetNode.getType()));
            }
            if (StringUtils.isNotBlank((String)linksetNode.getAnchor())) {
                responseBody.append(String.format("; anchor=\"%s\" ", linksetNode.getAnchor()));
            }
            responseBody.append(", ");
        });
        return responseBody.toString();
    }
}

