/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.MetadataValueReplacePatchOperation;
import org.dspace.app.rest.utils.BitstreamMetadataValuePathUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class BitstreamMetadataValueReplacePatchOperation
extends MetadataValueReplacePatchOperation<Bitstream> {
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    ItemService itemService;
    BitstreamMetadataValuePathUtils bitstreamMetadataValuePathUtils;

    @Override
    void replace(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String absolutePath = this.getAbsolutePath(path);
        String[] split = absolutePath.split("/");
        this.bitstreamMetadataValuePathUtils.validate(absolutePath);
        Item item = source.getItem();
        List bundle = this.itemService.getBundles(item, "ORIGINAL");
        for (Bundle bb : bundle) {
            int idx = 0;
            for (Bitstream b : bb.getBitstreams()) {
                if (idx == Integer.parseInt(split[1])) {
                    this.replace(context, b, split, value);
                }
                ++idx;
            }
        }
    }

    private void replace(Context context, Bitstream b, String[] split, Object value) throws SQLException, IllegalArgumentException, IllegalAccessException {
        String mdString = split[3];
        List metadataByMetadataString = this.bitstreamService.getMetadataByMetadataString((DSpaceObject)b, mdString);
        Assert.notEmpty((Collection)metadataByMetadataString, (String)"No metadata fields match ".concat(mdString));
        int index = Integer.parseInt(split[4]);
        if (split.length == 5) {
            MetadataValueRest obj = (MetadataValueRest)this.evaluateSingleObject((LateObjectEvaluator)value);
            this.replaceValue(context, b, mdString, metadataByMetadataString, obj, index);
        } else if (split.length > 5) {
            this.setDeclaredField(context, b, value, mdString, split[5], metadataByMetadataString, index);
        }
    }

    protected BitstreamService getDSpaceObjectService() {
        return this.bitstreamService;
    }

    public void setBitstreamMetadataValuePathUtils(BitstreamMetadataValuePathUtils bitstreamMetadataValuePathUtils) {
        this.bitstreamMetadataValuePathUtils = bitstreamMetadataValuePathUtils;
    }
}

