/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.ldn.NotifyPatternToTrigger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.AddPatchOperation;
import org.dspace.app.rest.submit.factory.impl.NotifySubmissionService;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyServiceAddPatchOperation
extends AddPatchOperation<Integer> {
    @Autowired
    private NotifyPatternToTriggerService notifyPatternToTriggerService;
    @Autowired
    private NotifyService notifyService;
    private NotifySubmissionService coarNotifySubmissionService = (NotifySubmissionService)new DSpace().getServiceManager().getServiceByName("coarNotifySubmissionService", NotifySubmissionService.class);

    @Override
    protected Class<Integer[]> getArrayClassForEvaluation() {
        return Integer[].class;
    }

    @Override
    protected Class<Integer> getClassForEvaluation() {
        return Integer.class;
    }

    @Override
    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String pattern = this.coarNotifySubmissionService.extractPattern(path);
        LinkedHashSet<Integer> servicesIds = new LinkedHashSet<Integer>(this.evaluateArrayObject((LateObjectEvaluator)value));
        this.coarNotifySubmissionService.checkCompatibilityWithPattern(context, pattern, servicesIds);
        List<NotifyServiceEntity> services = servicesIds.stream().map(id -> this.findService(context, (int)id)).collect(Collectors.toList());
        if (services.isEmpty()) {
            this.createNotifyPattern(context, source.getItem(), null, pattern);
        } else {
            services.forEach(service -> this.createNotifyPattern(context, source.getItem(), (NotifyServiceEntity)service, pattern));
        }
    }

    private NotifyServiceEntity findService(Context context, int serviceId) {
        try {
            NotifyServiceEntity service = this.notifyService.find(context, Integer.valueOf(serviceId));
            if (service == null) {
                throw new UnprocessableEntityException("no service found for the provided value: " + serviceId);
            }
            return service;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createNotifyPattern(Context context, Item item, NotifyServiceEntity service, String pattern) {
        try {
            NotifyPatternToTrigger notifyPatternToTrigger = this.notifyPatternToTriggerService.create(context);
            notifyPatternToTrigger.setItem(item);
            notifyPatternToTrigger.setNotifyService(service);
            notifyPatternToTrigger.setPattern(pattern);
            this.notifyPatternToTriggerService.update(context, notifyPatternToTrigger);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

