/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.hateoas.BitstreamResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.HttpHeadersInitializer;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.EventService;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/bitstreams/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
public class BitstreamRestController {
    private static final Logger log = LogManager.getLogger(BitstreamRestController.class);
    private static final int BUFFER_SIZE = 40960;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    private EventService eventService;
    @Autowired
    private CitationDocumentService citationDocumentService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    ConverterService converter;
    @Autowired
    Utils utils;

    @PreAuthorize(value="hasPermission(#uuid, 'BITSTREAM', 'READ')")
    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"content"})
    public ResponseEntity retrieve(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws IOException, SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        Bitstream bit = this.bitstreamService.find(context, uuid);
        EPerson currentUser = context.getCurrentUser();
        if (bit == null) {
            response.sendError(404);
            return null;
        }
        Long lastModified = this.bitstreamService.getLastModified(bit);
        BitstreamFormat format = bit.getFormat(context);
        String mimetype = format.getMIMEType();
        String name = this.getBitstreamName(bit, format);
        if (StringUtils.isBlank((CharSequence)request.getHeader("Range"))) {
            this.eventService.fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)bit));
        }
        try {
            long dispositionThreshold;
            long filesize = bit.getSizeBytes();
            Boolean citationEnabledForBitstream = this.citationDocumentService.isCitationEnabledForBitstream(bit, context);
            HttpHeadersInitializer httpHeadersInitializer = new HttpHeadersInitializer().withBufferSize(40960).withFileName(name).withChecksum(bit.getChecksum()).withLength(bit.getSizeBytes()).withMimetype(mimetype).with(request).with(response);
            if (lastModified != null) {
                httpHeadersInitializer.withLastModified(lastModified);
            }
            if ((dispositionThreshold = this.configurationService.getLongProperty("webui.content_disposition_threshold")) >= 0L && filesize > dispositionThreshold || this.checkFormatForContentDisposition(format)) {
                httpHeadersInitializer.withDisposition("attachment");
            }
            org.dspace.app.rest.utils.BitstreamResource bitstreamResource = new org.dspace.app.rest.utils.BitstreamResource(name, uuid, currentUser != null ? currentUser.getID() : null, context.getSpecialGroupUuids(), citationEnabledForBitstream);
            context.complete();
            if (httpHeadersInitializer.isValid()) {
                HttpHeaders httpHeaders = httpHeadersInitializer.initialiseHeaders();
                if (RequestMethod.HEAD.name().equals(request.getMethod())) {
                    log.debug("HEAD request - no response body");
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).build();
                }
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)bitstreamResource);
            }
        }
        catch (ClientAbortException ex) {
            log.debug("Client aborted the request before the download was completed. Client is probably switching to a Range request.", (Throwable)ex);
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    private String getBitstreamName(Bitstream bit, BitstreamFormat format) {
        Object name = bit.getName();
        if (name == null) {
            name = bit.getID().toString();
            if (format != null && format.getExtensions() != null && format.getExtensions().size() > 0) {
                name = (String)name + "." + (String)format.getExtensions().get(0);
            }
        }
        return name;
    }

    private boolean isNotAnErrorResponse(HttpServletResponse response) {
        Response.Status.Family responseCode = Response.Status.Family.familyOf((int)response.getStatus());
        return responseCode.equals((Object)Response.Status.Family.SUCCESSFUL) || responseCode.equals((Object)Response.Status.Family.REDIRECTION);
    }

    private boolean checkFormatForContentDisposition(BitstreamFormat format) {
        if (format == null || format.getSupportLevel() == 0) {
            return true;
        }
        List<String> configuredFormats = List.of(this.configurationService.getArrayProperty("webui.content_disposition_format"));
        if (configuredFormats.contains("*")) {
            return true;
        }
        List<String> downloadOnlyFormats = List.of("text/html", "text/javascript", "text/xml", "rdf");
        List formats = ListUtils.union(downloadOnlyFormats, configuredFormats);
        boolean download = formats.contains(format.getMIMEType());
        if (!download) {
            for (String ext : format.getExtensions()) {
                if (!formats.contains(ext)) continue;
                download = true;
                break;
            }
        }
        return download;
    }

    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"}, value={"format"})
    @PreAuthorize(value="hasPermission(#uuid, 'BITSTREAM','WRITE')")
    @PostAuthorize(value="returnObject != null")
    public BitstreamResource updateBitstreamFormat(@PathVariable UUID uuid, HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        List<BitstreamFormat> bitstreamFormats = this.utils.constructBitstreamFormatList(request, context);
        if (bitstreamFormats.size() > 1) {
            throw new DSpaceBadRequestException("Only one bitstream format is allowed");
        }
        BitstreamFormat bitstreamFormat = (BitstreamFormat)bitstreamFormats.stream().findFirst().orElseThrow(() -> new DSpaceBadRequestException("No valid bitstream format was provided"));
        Bitstream bitstream = this.bitstreamService.find(context, uuid);
        if (bitstream == null) {
            throw new ResourceNotFoundException("Bitstream with id: " + uuid + " not found");
        }
        bitstream.setFormat(context, bitstreamFormat);
        context.commit();
        BitstreamRest bitstreamRest = (BitstreamRest)this.converter.toRest((Bitstream)context.reloadEntity((ReloadableEntity)bitstream), this.utils.obtainProjection());
        return (BitstreamResource)((Object)this.converter.toResource(bitstreamRest));
    }
}

