/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.hateoas.BitstreamResource;
import org.dspace.app.rest.repository.CollectionRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/core/collections/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/logo"})
public class CollectionLogoController {
    @Autowired
    protected Utils utils;
    @Autowired
    private CollectionRestRepository collectionRestRepository;
    @Autowired
    private CollectionService collectionService;

    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    @RequestMapping(method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public ResponseEntity<RepresentationModel<?>> createLogo(HttpServletRequest request, @PathVariable UUID uuid, @RequestParam(value="file", required=false) MultipartFile uploadfile) throws SQLException, IOException, AuthorizeException {
        if (uploadfile == null) {
            throw new UnprocessableEntityException("No file was given");
        }
        Context context = ContextUtil.obtainContext(request);
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("The given uuid did not resolve to a collection on the server: " + uuid);
        }
        BitstreamRest bitstream = this.collectionRestRepository.setLogo(context, collection, uploadfile);
        BitstreamResource bitstreamResource = new BitstreamResource(bitstream, this.utils);
        context.complete();
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)bitstreamResource);
    }
}

