/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Objects;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.impl.DeleteFeature;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canDeleteVersion", description="It can be used to verify if the user can delete a version of an Item")
public class CanDeleteVersionFeature
extends DeleteFeature {
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private ConfigurationService configurationService;
    public static final String NAME = "canDeleteVersion";

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof VersionRest) {
            if (!this.configurationService.getBooleanProperty("versioning.enabled", true)) {
                return false;
            }
            Version version = this.versioningService.getVersion(context, ((VersionRest)object).getId().intValue());
            if (Objects.nonNull(version) && Objects.nonNull(version.getItem())) {
                ItemRest itemRest = this.itemConverter.convert(version.getItem(), DefaultProjection.DEFAULT);
                return super.isAuthorized(context, itemRest);
            }
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"versioning.version"};
    }
}

