/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageGroup", description="It can be used to verify if the current user can manage a specific group")
public class ManageGroupFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageGroup";
    @Autowired
    GroupService groupService;
    @Autowired
    AuthorizeService authorizeService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (!(object instanceof GroupRest)) {
            return false;
        }
        GroupRest groupRest = (GroupRest)object;
        Group group = this.groupService.findByName(context, groupRest.getName());
        if (group == null) {
            return false;
        }
        if (this.authorizeService.isAdmin(context)) {
            return true;
        }
        if (!StringUtils.startsWith((CharSequence)group.getName(), (CharSequence)"COLLECTION_") && !StringUtils.startsWith((CharSequence)group.getName(), (CharSequence)"COMMUNITY_")) {
            return false;
        }
        return this.authorizeService.isAdmin(context, (DSpaceObject)group);
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"eperson.group"};
    }
}

