/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchException;

public class JsonValueEvaluator
implements LateObjectEvaluator {
    @Nonnull
    private final ObjectMapper mapper;
    @Nonnull
    private final JsonNode valueNode;

    public JsonValueEvaluator(ObjectMapper mapper, JsonNode valueNode) {
        this.mapper = mapper;
        this.valueNode = valueNode;
    }

    @Override
    public <T> Object evaluate(Class<T> type) {
        try {
            return this.mapper.readValue(this.valueNode.traverse(), type);
        }
        catch (Exception e) {
            throw new PatchException(String.format("Could not read %s into %s!", this.valueNode, type), e);
        }
    }

    public JsonNode getValueNode() {
        return this.valueNode;
    }
}

