/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.authorizations.object")
public class AuthorizationObjectLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private AuthorizationRestUtil authorizationRestUtil;

    @PreAuthorize(value="hasPermission(#authzId, 'AUTHORIZATION', 'READ')")
    public BaseObjectRest getObject(@Nullable HttpServletRequest request, String authzId, @Nullable Pageable optionalPageable, Projection projection) {
        BaseObjectRest object;
        Context context = this.obtainContext();
        try {
            object = this.authorizationRestUtil.getObject(context, authzId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return object;
    }
}

