/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.communities.parentCommunity")
public class CommunityParentCommunityLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private CommunityService communityService;

    @PreAuthorize(value="hasPermission(#communityId, 'COMMUNITY', 'READ')")
    public CommunityRest getParentCommunity(@Nullable HttpServletRequest httpServletRequest, UUID communityId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Community community = (Community)this.communityService.find(context, communityId);
            if (community == null) {
                throw new ResourceNotFoundException("No such community: " + communityId);
            }
            Community parentCommunity = (Community)this.communityService.getParentObject(context, (DSpaceObject)community);
            if (parentCommunity == null) {
                return null;
            }
            return (CommunityRest)this.converter.toRest(parentCommunity, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

