/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.VocabularyEntryDetailsRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.vocabularyEntryDetails.parent")
public class VocabularyEntryDetailsParentLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ChoiceAuthorityService choiceAuthorityService;
    @Autowired
    private AuthorityUtils authorityUtils;

    @PreAuthorize(value="permitAll()")
    public VocabularyEntryDetailsRest getParent(@Nullable HttpServletRequest request, String name, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        String[] parts = StringUtils.split((String)name, (String)":", (int)2);
        if (parts.length != 2) {
            return null;
        }
        String vocabularyName = parts[0];
        String id = parts[1];
        ChoiceAuthority authority = this.choiceAuthorityService.getChoiceAuthorityByAuthorityName(vocabularyName);
        Choice choice = null;
        if (!StringUtils.isNotBlank((CharSequence)id) || authority == null || !authority.isHierarchical()) {
            throw new NotFoundException();
        }
        choice = this.choiceAuthorityService.getParentChoice(vocabularyName, id, context.getCurrentLocale().toString());
        return this.authorityUtils.convertEntryDetails(choice, vocabularyName, authority.isHierarchical(), this.utils.obtainProjection());
    }
}

