/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePatch<M> {
    @Autowired
    private List<PatchOperation> patchOperations;

    public void patch(Context context, M dso, List<Operation> operations) throws SQLException {
        for (Operation operation : operations) {
            this.performPatchOperation(context, dso, operation);
        }
    }

    protected void performPatchOperation(Context context, M object, Operation operation) throws DSpaceBadRequestException, SQLException {
        for (PatchOperation patchOperation : this.patchOperations) {
            if (!patchOperation.supports(object, operation)) continue;
            patchOperation.perform(context, object, operation);
            return;
        }
        throw new DSpaceBadRequestException("This operation is not supported.");
    }
}

