/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupNameReplaceOperation<R>
extends PatchOperation<R> {
    @Autowired
    GroupService groupService;
    private static final String OPERATION_PATH_NAME = "/name";

    @Override
    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
            Group group = (Group)object;
            this.checkModelForExistingValue(group);
            this.checkForProcessability(context, group);
            try {
                groupService.setName(group, (String)operation.getValue());
            }
            catch (SQLException e) {
                throw new DSpaceBadRequestException("SQLException in GroupNameReplaceOperation.perform trying to replace the name of the group.", e);
            }
            return object;
        }
        throw new DSpaceBadRequestException("GroupNameReplaceOperation does not support this operation");
    }

    private void checkModelForExistingValue(Group group) {
        if (group.getName() == null) {
            throw new DSpaceBadRequestException("Attempting to replace a non-existent value (name).");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof Group && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_NAME);
    }

    private void checkForProcessability(Context context, Group group) {
        try {
            if (group.isPermanent().booleanValue()) {
                throw new UnprocessableEntityException("A permanent group's name cannot be patched");
            }
            DSpaceObject parentObject = this.groupService.getParentObject(context, (DSpaceObject)group);
            if (parentObject != null) {
                throw new UnprocessableEntityException("This group's name cannot be patched as it has a parent " + parentObject.getType() + " with id " + parentObject.getID());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

