/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class StatelessLoginFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger log = LogManager.getLogger();
    protected AuthenticationManager authenticationManager;
    protected RestAuthenticationService restAuthenticationService;

    public void afterPropertiesSet() {
    }

    public StatelessLoginFilter(String url, String httpMethod, AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService) {
        super((RequestMatcher)new AntPathRequestMatcher(url, httpMethod));
        this.authenticationManager = authenticationManager;
        this.restAuthenticationService = restAuthenticationService;
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        String user = req.getParameter("user");
        String password = req.getParameter("password");
        return this.authenticationManager.authenticate((Authentication)new DSpaceAuthentication(user, password));
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        DSpaceAuthentication dSpaceAuthentication = (DSpaceAuthentication)auth;
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = dSpaceAuthentication::getName;
        log.debug("Authentication successful for EPerson {}", supplierArray);
        this.restAuthenticationService.addAuthenticationDataForUser(req, res, dSpaceAuthentication, false);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        String authenticateHeaderValue = this.restAuthenticationService.getWwwAuthenticateHeaderValue(request, response);
        response.setHeader("WWW-Authenticate", authenticateHeaderValue);
        response.sendError(401, "Authentication failed!");
        log.error("Authentication failed (status:{})", (Object)401, (Object)failed);
    }
}

