/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.bitstream;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.bitstream.BitstreamSignpostingProcessor;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;

public class BitstreamParentItemProcessor
extends BitstreamSignpostingProcessor {
    private static final Logger log = Logger.getLogger(BitstreamParentItemProcessor.class);
    private final BitstreamService bitstreamService;

    public BitstreamParentItemProcessor(FrontendUrlService frontendUrlService, BitstreamService bitstreamService) {
        super(frontendUrlService);
        this.bitstreamService = bitstreamService;
        this.setRelation(LinksetRelationType.COLLECTION);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Bitstream bitstream, List<LinksetNode> linksetNodes) {
        try {
            Item item = (Item)this.bitstreamService.getParentObject(context, (DSpaceObject)bitstream);
            if (item != null) {
                String itemUiUrl = this.frontendUrlService.generateUrl(context, item);
                linksetNodes.add(new LinksetNode(itemUiUrl, this.getRelation(), "text/html", this.buildAnchor(bitstream)));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

