/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.bitstream;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.bitstream.BitstreamSignpostingProcessor;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;
import org.dspace.util.SimpleMapConverter;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamTypeProcessor
extends BitstreamSignpostingProcessor {
    private static final Logger log = Logger.getLogger(BitstreamTypeProcessor.class);
    @Autowired
    private SimpleMapConverter mapConverterDSpaceToSchemaOrgUri;
    @Autowired
    private BitstreamService bitstreamService;

    public BitstreamTypeProcessor(FrontendUrlService frontendUrlService) {
        super(frontendUrlService);
        this.setRelation(LinksetRelationType.TYPE);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Bitstream bitstream, List<LinksetNode> linksetNodes) {
        try {
            String type = this.bitstreamService.getMetadataFirstValue((DSpaceObject)bitstream, "dc", "type", null, "*");
            if (StringUtils.isNotBlank((CharSequence)type)) {
                String typeSchemeUri = this.mapConverterDSpaceToSchemaOrgUri.getValue(type);
                linksetNodes.add(new LinksetNode(typeSchemeUri, this.getRelation(), this.buildAnchor(bitstream)));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

