/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;

public class ItemAuthorProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = Logger.getLogger(ItemAuthorProcessor.class);
    private final ItemService itemService;
    private String orcidMetadata;

    public ItemAuthorProcessor(FrontendUrlService frontendUrlService, ItemService itemService) {
        super(frontendUrlService);
        this.itemService = itemService;
        this.setRelation(LinksetRelationType.AUTHOR);
    }

    public String getOrcidMetadata() {
        return this.orcidMetadata;
    }

    public void setOrcidMetadata(String orcidMetadata) {
        this.orcidMetadata = orcidMetadata;
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            String authorOrcid;
            Item author;
            String authorId = this.itemService.getMetadataFirstValue((DSpaceObject)item, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
            if (StringUtils.isNotBlank((String)authorId) && Objects.nonNull(author = (Item)this.itemService.findByIdOrLegacyId(context, authorId)) && StringUtils.isNotBlank((String)(authorOrcid = this.itemService.getMetadataFirstValue((DSpaceObject)author, new MetadataFieldName(this.getOrcidMetadata()), "*")))) {
                String authorLink = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getPattern()) ? authorOrcid : MessageFormat.format(this.getPattern(), authorOrcid);
                linksetNodes.add(new LinksetNode(authorLink, this.getRelation(), this.buildAnchor(context, item)));
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem to add signposting pattern", (Throwable)e);
        }
    }
}

