/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.util.FrontendUrlService;

public class ItemLicenseProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = Logger.getLogger(ItemLicenseProcessor.class);
    private final CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();

    public ItemLicenseProcessor(FrontendUrlService frontendUrlService) {
        super(frontendUrlService);
        this.setRelation(LinksetRelationType.LICENSE);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            String licenseUrl = this.creativeCommonsService.getLicenseURL(context, item);
            if (StringUtils.isNotBlank((CharSequence)licenseUrl)) {
                linksetNodes.add(new LinksetNode(licenseUrl, this.getRelation(), this.buildAnchor(context, item)));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

