/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.util.FrontendUrlService;

public class ItemLinksetProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = Logger.getLogger(ItemLinksetProcessor.class);
    private final ConfigurationService configurationService;

    public ItemLinksetProcessor(FrontendUrlService frontendUrlService, ConfigurationService configurationService) {
        super(frontendUrlService);
        this.configurationService = configurationService;
        this.setRelation(LinksetRelationType.LINKSET);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            if (item != null) {
                String signpostingPath = this.configurationService.getProperty("signposting.path");
                String baseUrl = this.configurationService.getProperty("dspace.ui.url");
                String linksetUrl = String.format("%s/%s/linksets/%s", baseUrl, signpostingPath, item.getID());
                String linksetJsonUrl = linksetUrl + "/json";
                String anchor = this.buildAnchor(context, item);
                List<LinksetNode> links = List.of(new LinksetNode(linksetUrl, this.getRelation(), "application/linkset", anchor), new LinksetNode(linksetJsonUrl, this.getRelation(), "application/linkset+json", anchor));
                linksetNodes.addAll(links);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

