/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.dspace.app.rest.submit.factory.impl.MetadataValueMovePatchOperation;
import org.dspace.app.rest.utils.BitstreamMetadataValuePathUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamMetadataValueMovePatchOperation
extends MetadataValueMovePatchOperation<Bitstream> {
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    ItemService itemService;
    BitstreamMetadataValuePathUtils bitstreamMetadataValuePathUtils;

    @Override
    void move(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, String from) throws Exception {
        String stepId = this.getStepId(path);
        String absolutePath = this.getAbsolutePath(path);
        String[] splitTo = absolutePath.split("/");
        this.bitstreamMetadataValuePathUtils.validate(stepId, absolutePath);
        Item item = source.getItem();
        List bundle = this.itemService.getBundles(item, "ORIGINAL");
        for (Bundle bb : bundle) {
            int idx = 0;
            for (Bitstream b : bb.getBitstreams()) {
                if (idx != Integer.parseInt(splitTo[1])) continue;
                String evalFrom = this.getAbsolutePath(from);
                String[] splitFrom = evalFrom.split("/");
                String metadata = splitFrom[3];
                if (splitTo.length <= 4) continue;
                String stringTo = splitTo[4];
                if (splitFrom.length <= 4) continue;
                String stringFrom = splitFrom[4];
                int intTo = Integer.parseInt(stringTo);
                int intFrom = Integer.parseInt(stringFrom);
                this.moveValue(context, b, metadata, intFrom, intTo);
            }
        }
    }

    protected BitstreamService getDSpaceObjectService() {
        return this.bitstreamService;
    }

    public void setBitstreamMetadataValuePathUtils(BitstreamMetadataValuePathUtils bitstreamMetadataValuePathUtils) {
        this.bitstreamMetadataValuePathUtils = bitstreamMetadataValuePathUtils;
    }
}

