/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.submit.factory.impl.AddPatchOperation;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.license.service.CreativeCommonsService;
import org.springframework.beans.factory.annotation.Autowired;

public class CCLicenseAddPatchOperation
extends AddPatchOperation<String> {
    @Autowired
    CreativeCommonsService creativeCommonsService;

    @Override
    protected Class<String[]> getArrayClassForEvaluation() {
        return String[].class;
    }

    @Override
    protected Class<String> getClassForEvaluation() {
        return String.class;
    }

    @Override
    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String licenseUri = null;
        if (value instanceof String) {
            licenseUri = (String)value;
        }
        if (StringUtils.isBlank(licenseUri)) {
            throw new IllegalArgumentException("Value is not a valid license URI");
        }
        Item item = source.getItem();
        boolean updateLicense = this.creativeCommonsService.updateLicense(context, licenseUri, item);
        if (!updateLicense) {
            throw new IllegalArgumentException("The license uri: " + licenseUri + ", could not be resolved to a CC license");
        }
    }
}

