/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.utils.DSpace;
import org.springframework.core.io.AbstractResource;

public class BitstreamResource
extends AbstractResource {
    private String name;
    private UUID uuid;
    private UUID currentUserUUID;
    private boolean shouldGenerateCoverPage;
    private byte[] file;
    private Set<UUID> currentSpecialGroups;
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private CitationDocumentService citationDocumentService = (CitationDocumentService)new DSpace().getServiceManager().getServicesByType(CitationDocumentService.class).get(0);

    public BitstreamResource(String name, UUID uuid, UUID currentUserUUID, Set<UUID> currentSpecialGroups, boolean shouldGenerateCoverPage) {
        this.name = name;
        this.uuid = uuid;
        this.currentUserUUID = currentUserUUID;
        this.currentSpecialGroups = currentSpecialGroups;
        this.shouldGenerateCoverPage = shouldGenerateCoverPage;
    }

    private byte[] getCoverpageByteArray(Context context, Bitstream bitstream) throws IOException, SQLException, AuthorizeException {
        if (this.file == null) {
            try {
                Pair citedDocument = this.citationDocumentService.makeCitedDocument(context, bitstream);
                this.file = (byte[])citedDocument.getLeft();
            }
            catch (Exception e) {
                this.file = IOUtils.toByteArray((InputStream)this.bitstreamService.retrieve(context, bitstream));
            }
        }
        return this.file;
    }

    public String getDescription() {
        return "bitstream [" + this.uuid + "]";
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream;
        block8: {
            Context context = this.initializeContext();
            try {
                Bitstream bitstream = this.bitstreamService.find(context, this.uuid);
                InputStream out = this.shouldGenerateCoverPage ? new ByteArrayInputStream(this.getCoverpageByteArray(context, bitstream)) : this.bitstreamService.retrieve(context, bitstream);
                this.file = null;
                inputStream = out;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | AuthorizeException e) {
                    throw new IOException(e);
                }
            }
            context.close();
        }
        return inputStream;
    }

    public String getFilename() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long contentLength() throws IOException {
        try (Context context = this.initializeContext();){
            Bitstream bitstream = this.bitstreamService.find(context, this.uuid);
            if (this.shouldGenerateCoverPage) {
                long l2 = this.getCoverpageByteArray(context, bitstream).length;
                return l2;
            }
            long l = bitstream.getSizeBytes();
            return l;
        }
        catch (SQLException | AuthorizeException e) {
            throw new IOException(e);
        }
    }

    private Context initializeContext() throws SQLException {
        Context context = new Context();
        EPerson currentUser = (EPerson)this.ePersonService.find(context, this.currentUserUUID);
        context.setCurrentUser(currentUser);
        this.currentSpecialGroups.forEach(arg_0 -> ((Context)context).setSpecialGroup(arg_0));
        return context;
    }
}

