/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class URLUtils {
    private URLUtils() {
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static boolean urlIsPrefixOf(String pattern, String candidate) throws IllegalArgumentException {
        int candidatePort;
        URL candidateURL;
        URL patternURL;
        try {
            patternURL = new URL(pattern);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The pattern URL is not valid:  " + pattern);
        }
        try {
            candidateURL = new URL(candidate);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The candidate URL is not valid:  " + candidate);
        }
        int patternPort = patternURL.getPort();
        if (patternPort < 0) {
            patternPort = patternURL.getDefaultPort();
        }
        if ((candidatePort = candidateURL.getPort()) < 0) {
            candidatePort = candidateURL.getDefaultPort();
        }
        boolean isPrefix = StringUtils.equals((CharSequence)candidateURL.getProtocol(), (CharSequence)patternURL.getProtocol());
        isPrefix &= StringUtils.equals((CharSequence)candidateURL.getHost(), (CharSequence)patternURL.getHost());
        isPrefix &= candidatePort == patternPort;
        String[] candidateElements = StringUtils.split((String)candidateURL.getPath(), (char)'/');
        String[] patternElements = StringUtils.split((String)patternURL.getPath(), (char)'/');
        if (patternElements.length > candidateElements.length) {
            return false;
        }
        for (int elementN = 0; elementN < patternElements.length; ++elementN) {
            isPrefix &= candidateElements[elementN].equals(patternElements[elementN]);
        }
        return isPrefix;
    }
}

