/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSpaceKernelInit {
    private static Logger log = LoggerFactory.getLogger(DSpaceKernelInit.class);
    private static final Object staticLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSpaceKernelImpl getKernel(String name) {
        if (name != null) {
            try {
                DSpaceKernel kernel = new DSpaceKernelManager().getKernel(name);
                if (kernel != null) {
                    if (kernel instanceof DSpaceKernelImpl) {
                        return (DSpaceKernelImpl)kernel;
                    }
                    throw new IllegalStateException("Wrong DSpaceKernel implementation");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = staticLock;
        synchronized (object) {
            DSpaceKernelImpl kernelImpl = new DSpaceKernelImpl(name);
            log.info("Created new kernel: " + kernelImpl);
            if (name != null) {
                DSpaceKernelManager.registerMBean((String)kernelImpl.getMBeanName(), (DSpaceKernel)kernelImpl);
            } else {
                DSpaceKernelManager.setDefaultKernel((DSpaceKernel)kernelImpl);
            }
            return kernelImpl;
        }
    }
}

