/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import org.dspace.servicemanager.DSpaceServiceManager;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public final class DSpaceBeanPostProcessor
implements BeanPostProcessor,
DestructionAwareBeanPostProcessor {
    private DSpaceConfigurationService configurationService;

    @Autowired
    public DSpaceBeanPostProcessor(DSpaceConfigurationService configurationService) {
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service cannot be null");
        }
        this.configurationService = configurationService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        DSpaceServiceManager.configureService(beanName, bean, this.configurationService.getServiceNameConfigs());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        DSpaceServiceManager.initService(bean);
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        DSpaceServiceManager.shutdownService(bean);
    }
}

