/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils.servicemanager;

import java.lang.ref.WeakReference;
import org.dspace.utils.servicemanager.ProviderNotFoundException;

public final class ProviderHolder<T> {
    private WeakReference<T> providerReference = null;

    public ProviderHolder() {
    }

    public ProviderHolder(T provider) {
        this.setProvider(provider);
    }

    public T getProvider() {
        T t = null;
        if (this.providerReference != null) {
            t = this.providerReference.get();
        }
        return t;
    }

    public T getProviderOrFail() {
        T t = this.getProvider();
        if (t == null) {
            throw new ProviderNotFoundException("Could not get provider from this holder, none available");
        }
        return t;
    }

    public void setProvider(T provider) {
        if (provider == null) {
            if (this.providerReference != null) {
                this.providerReference.clear();
            }
            this.providerReference = null;
        } else {
            this.providerReference = new WeakReference<T>(provider);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        T provider = this.getProvider();
        result = 31 * result + (provider == null ? 0 : provider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderHolder other = (ProviderHolder)obj;
        T provider = this.getProvider();
        T otherProvider = other.getProvider();
        if (provider == null || otherProvider == null) {
            return false;
        }
        return provider.equals(otherProvider);
    }

    public String toString() {
        T provider = this.getProvider();
        return "ph:" + (provider == null ? null : provider.getClass() + ":" + provider) + ": " + super.toString();
    }
}

