/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.GenericStatementDisseminator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordStatementDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.AtomStatement;
import org.swordapp.server.Statement;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class AtomStatementDisseminator
extends GenericStatementDisseminator
implements SwordStatementDisseminator {
    @Override
    public Statement disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = new SwordUrlManager(new SwordConfigurationDSpace(), context);
        String feedUri = urlManager.getAtomStatementUri(item);
        String authorField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"author.field");
        String titleField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"title.field");
        String updatedField = ConfigurationManager.getProperty((String)"swordv2-server", (String)"updated.field");
        String author = this.stringMetadata(item, authorField);
        String title = this.stringMetadata(item, titleField);
        String updated = this.stringMetadata(item, updatedField);
        AtomStatement s = new AtomStatement(feedUri, author, title, updated);
        this.populateStatement(context, item, (Statement)s);
        return s;
    }

    private String stringMetadata(Item item, String field) {
        if (field == null) {
            return null;
        }
        DCValue[] dcvs = item.getMetadata(field);
        if (dcvs == null) {
            return null;
        }
        StringBuilder md = new StringBuilder();
        for (DCValue dcv : dcvs) {
            if (md.length() > 0) {
                md.append(", ");
            }
            md.append(dcv.value);
        }
        return md.toString();
    }
}

