/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword2.ContainerManagerDSpace;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.ReceiptGenerator;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordIngesterFactory;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.VerboseDescription;
import org.dspace.sword2.VersionManager;
import org.dspace.sword2.WorkflowManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.MediaResource;
import org.swordapp.server.MediaResourceManager;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class MediaResourceManagerDSpace
extends DSpaceSwordAPI
implements MediaResourceManager {
    private static Logger log = Logger.getLogger(MediaResourceManagerDSpace.class);
    private VerboseDescription verboseDescription = new VerboseDescription();

    public MediaResource getMediaResourceRepresentation(String uri, Map<String, String> accept, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        try {
            SwordContext sc = null;
            SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
            SwordAuthenticator auth = new SwordAuthenticator();
            sc = auth.authenticate(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_get_media_resource", (String)""));
            }
            String un = authCredentials.getUsername() != null ? authCredentials.getUsername() : "NONE";
            String obo = authCredentials.getOnBehalfOf() != null ? authCredentials.getOnBehalfOf() : "NONE";
            log.info((Object)LogManager.getHeader((Context)context, (String)"sword_get_media_resource", (String)("username=" + un + ",on_behalf_of=" + obo)));
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            if (urlManager.isActionableBitstreamUrl(context, uri)) {
                Bitstream bitstream = urlManager.getBitstream(context, uri);
                WorkflowManagerFactory.getInstance().retrieveBitstream(context, bitstream);
                InputStream stream = bitstream.retrieve();
                MediaResource mr = new MediaResource(stream, bitstream.getFormat().getMIMEType(), null, true);
                mr.setContentMD5(bitstream.getChecksum());
                mr.setLastModified(this.getLastModified(context, bitstream));
                return mr;
            }
            Item item = urlManager.getItem(context, uri);
            boolean feedRequest = urlManager.isFeedRequest(context, uri);
            WorkflowManagerFactory.getInstance().retrieveContent(context, item);
            SwordContentDisseminator disseminator = null;
            if (!feedRequest) {
                String acceptContentType = this.getHeader(accept, "Accept", null);
                String acceptPackaging = this.getHeader(accept, "Accept-Packaging", UriRegistry.PACKAGE_SIMPLE_ZIP);
                TreeMap<Float, List<String>> analysed = this.analyseAccept(acceptContentType);
                disseminator = SwordDisseminatorFactory.getContentInstance(analysed, acceptPackaging);
            } else {
                HashMap<Float, List<String>> analysed = new HashMap<Float, List<String>>();
                ArrayList<String> list = new ArrayList<String>();
                list.add("application/atom+xml");
                analysed.put(Float.valueOf(1.0f), list);
                disseminator = SwordDisseminatorFactory.getContentInstance(analysed, null);
            }
            InputStream stream = disseminator.disseminate(context, item);
            MediaResource mr = new MediaResource(stream, disseminator.getContentType(), disseminator.getPackaging());
            return mr;
        }
        catch (DSpaceSwordException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (IOException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordServerException((Throwable)e);
        }
    }

    private Date getLastModified(Context context, Bitstream bitstream) throws SQLException {
        Date lm = null;
        for (Bundle bundle : bitstream.getBundles()) {
            for (Item item : bundle.getItems()) {
                Date possible = item.getLastModified();
                if (lm == null) {
                    lm = possible;
                    continue;
                }
                if (possible.getTime() <= lm.getTime()) continue;
                lm = possible;
            }
        }
        if (lm == null) {
            return new Date();
        }
        return lm;
    }

    public DepositReceipt replaceMediaResource(String emUri, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose replace of media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            WorkflowManager wfm;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_replace", (String)""));
            }
            DepositReceipt receipt = null;
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            if (urlManager.isActionableBitstreamUrl(context, emUri)) {
                Bitstream bitstream = urlManager.getBitstream(context, emUri);
                wfm = WorkflowManagerFactory.getInstance();
                wfm.replaceBitstream(context, bitstream);
                ArrayList<Item> items = new ArrayList<Item>();
                for (Bundle bundle : bitstream.getBundles()) {
                    for (Item item : bundle.getItems()) {
                        this.checkAuth(sc, item);
                        items.add(item);
                    }
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                DepositResult result = null;
                try {
                    result = this.replaceBitstream(sc, items, bitstream, deposit, authCredentials, config);
                }
                catch (DSpaceSwordException e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + e));
                        }
                    }
                    throw e;
                }
                catch (SwordError e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + (Object)((Object)e)));
                        }
                    }
                    throw e;
                }
                wfm.resolveState(context, deposit, null, this.verboseDescription, false);
                ReceiptGenerator genny = new ReceiptGenerator();
                receipt = genny.createFileReceipt(context, result, config);
            } else {
                Item item = this.getDSpaceTarget(context, emUri, config);
                wfm = WorkflowManagerFactory.getInstance();
                wfm.replaceResourceContent(context, item);
                SwordAuthenticator auth = new SwordAuthenticator();
                if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                    String oboEmail = "none";
                    if (sc.getOnBehalfOf() != null) {
                        oboEmail = sc.getOnBehalfOf().getEmail();
                    }
                    log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                    throw new SwordAuthException("Cannot replace the given item with this context");
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                try {
                    this.replaceContent(sc, item, deposit, authCredentials, config);
                }
                catch (DSpaceSwordException e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + e));
                        }
                    }
                    throw e;
                }
                catch (SwordError e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + (Object)((Object)e)));
                        }
                    }
                    throw e;
                }
                wfm.resolveState(context, deposit, null, this.verboseDescription, false);
            }
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public void deleteMediaResource(String emUri, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose delete of media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_delete", (String)""));
            }
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            if (urlManager.isActionableBitstreamUrl(context, emUri)) {
                Bitstream bitstream = urlManager.getBitstream(context, emUri);
                wfm.deleteBitstream(context, bitstream);
                ArrayList<Item> items = new ArrayList<Item>();
                for (Bundle bundle : bitstream.getBundles()) {
                    for (Item item : bundle.getItems()) {
                        this.checkAuth(sc, item);
                        items.add(item);
                    }
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                this.removeBitstream(sc, bitstream, items, authCredentials, config);
            } else {
                Item item = this.getDSpaceTarget(context, emUri, config);
                wfm.deleteMediaResource(context, item);
                SwordAuthenticator auth = new SwordAuthenticator();
                if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                    String oboEmail = "none";
                    if (sc.getOnBehalfOf() != null) {
                        oboEmail = sc.getOnBehalfOf().getEmail();
                    }
                    log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                    throw new SwordAuthException("Cannot replace the given item with this context");
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                this.removeContent(sc, item, authCredentials, config);
            }
            wfm.resolveState(context, null, null, this.verboseDescription, false);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            sc.commit();
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt addResource(String emUri, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose add to media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_add", (String)""));
            }
            Item item = this.getDSpaceTarget(context, emUri, config);
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.addResourceContent(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot replace the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = null;
            try {
                result = this.addContent(sc, item, deposit, authCredentials, config);
                if (deposit.isMultipart()) {
                    ContainerManagerDSpace cm = new ContainerManagerDSpace();
                    result = cm.doAddMetadata(sc, item, deposit, authCredentials, config, result);
                }
            }
            catch (DSpaceSwordException e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storePackageAsFile(deposit, authCredentials, config);
                        if (deposit.isMultipart()) {
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + e));
                    }
                }
                throw e;
            }
            catch (SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storePackageAsFile(deposit, authCredentials, config);
                        if (deposit.isMultipart()) {
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, null, this.verboseDescription, false);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = deposit.getPackaging().equals(UriRegistry.PACKAGE_BINARY) ? genny.createFileReceipt(context, result, config) : genny.createReceipt(context, result, config, true);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for add processing: " + delta + " ms");
            receipt.setVerboseDescription(this.verboseDescription.toString());
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    private void removeContent(SwordContext swordContext, Item item, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordAuthException {
        try {
            Bundle[] originals;
            VersionManager vm = new VersionManager();
            for (Bundle original : originals = item.getBundles("ORIGINAL")) {
                vm.emptyBundle(item, original);
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void removeBitstream(SwordContext swordContext, Bitstream bitstream, List<Item> items, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordAuthException {
        try {
            VersionManager vm = new VersionManager();
            for (Item item : items) {
                vm.removeBitstream(item, bitstream);
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void replaceContent(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        SwordContentIngester si = SwordIngesterFactory.getContentInstance(context, deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        try {
            VersionManager vm = new VersionManager();
            vm.emptyBundle(item, "ORIGINAL");
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription);
        this.verboseDescription.append("Replace completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
    }

    private DepositResult replaceBitstream(SwordContext swordContext, List<Item> items, Bitstream bitstream, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        for (Item item : items) {
            this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        }
        SwordContentIngester si = SwordIngesterFactory.getContentInstance(context, deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        try {
            this.removeBitstream(swordContext, bitstream, items, authCredentials, swordConfig);
            DepositResult result = null;
            boolean first = true;
            for (Item item : items) {
                if (first) {
                    result = this.addContent(swordContext, item, deposit, authCredentials, swordConfig);
                    continue;
                }
                Bundle[] bundles = item.getBundles("ORIGINAL");
                if (bundles.length > 0) {
                    bundles[0].addBitstream(result.getOriginalDeposit());
                    continue;
                }
                Bundle bundle = item.createBundle("ORIGINAL");
                bundle.addBitstream(result.getOriginalDeposit());
            }
            this.verboseDescription.append("Replace completed successfully");
            return result;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    private DepositResult addContent(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        SwordContentIngester si = SwordIngesterFactory.getContentInstance(context, deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription);
        this.verboseDescription.append("Add completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    private Item getDSpaceTarget(Context context, String editMediaUrl, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        Item item = urlManager.getItem(context, editMediaUrl);
        this.verboseDescription.append("Performing replace using edit-media URL: " + editMediaUrl);
        this.verboseDescription.append("Location resolves to item with handle: " + item.getHandle());
        return item;
    }

    private void checkAuth(SwordContext sc, Item item) throws DSpaceSwordException, SwordError, SwordAuthException {
        Context context = sc.getContext();
        SwordAuthenticator auth = new SwordAuthenticator();
        if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
            String oboEmail = "none";
            if (sc.getOnBehalfOf() != null) {
                oboEmail = sc.getOnBehalfOf().getEmail();
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
            throw new SwordAuthException("Cannot replace the given item with this context");
        }
    }
}

