/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public abstract class AbstractSwordContentIngester
implements SwordContentIngester {
    @Override
    public abstract DepositResult ingest(Context var1, Deposit var2, DSpaceObject var3, VerboseDescription var4) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException;

    @Override
    public abstract DepositResult ingest(Context var1, Deposit var2, DSpaceObject var3, VerboseDescription var4, DepositResult var5) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException;

    protected BitstreamFormat getFormat(Context context, String fileName) throws SQLException {
        BitstreamFormat[] formats;
        String fext = null;
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot > -1) {
            fext = fileName.substring(lastDot + 1);
        }
        if (fext == null) {
            return null;
        }
        for (BitstreamFormat format : formats = BitstreamFormat.findAll((Context)context)) {
            String[] extensions;
            for (String ext : extensions = format.getExtensions()) {
                if (!ext.equals(fext)) continue;
                return format;
            }
        }
        return null;
    }

    protected void setUpdatedDate(Item item, VerboseDescription verboseDescription) throws DSpaceSwordException {
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        DCValue dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        DCDate date = new DCDate(new Date());
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, date.toString());
        verboseDescription.append("Updated date added to response from item metadata where available");
    }

    protected void setSlug(Item item, String slugVal, VerboseDescription verboseDescription) throws DSpaceSwordException {
        if (slugVal == null) {
            return;
        }
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        DCValue dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, slugVal);
        verboseDescription.append("Slug value set in response where available");
    }

    protected DCValue configToDC(String config, String def) {
        DCValue dcv = new DCValue();
        dcv.schema = def;
        dcv.element = def;
        dcv.qualifier = def;
        StringTokenizer stz = new StringTokenizer(config, ".");
        dcv.schema = stz.nextToken();
        dcv.element = stz.nextToken();
        if (stz.hasMoreTokens()) {
            dcv.qualifier = stz.nextToken();
        }
        return dcv;
    }
}

