/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class FeedContentDisseminator
implements SwordContentDisseminator {
    @Override
    public InputStream disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        try {
            Bundle[] originals;
            Abdera abdera = new Abdera();
            Feed feed = abdera.newFeed();
            for (Bundle original : originals = item.getBundles("ORIGINAL")) {
                Bitstream[] bss;
                for (Bitstream bitstream : bss = original.getBitstreams()) {
                    Entry entry = feed.addEntry();
                    this.populateEntry(context, entry, bitstream);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            feed.writeTo((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return bais;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void populateEntry(Context context, Entry entry, Bitstream bitstream) throws DSpaceSwordException {
        BitstreamFormat format = bitstream.getFormat();
        String contentType = null;
        if (format != null) {
            contentType = format.getMIMEType();
        }
        entry.setTitle(bitstream.getName());
        entry.setSummary(bitstream.getDescription());
        SwordUrlManager urlManager = new SwordUrlManager(new SwordConfigurationDSpace(), context);
        String bsUrl = urlManager.getBitstreamUrl(bitstream);
        entry.setContent(new IRI(bsUrl), contentType);
    }

    @Override
    public boolean disseminatesContentType(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return "application/atom+xml".equals(contentType) || "application/atom+xml;type=feed".equals(contentType);
    }

    @Override
    public boolean disseminatesPackage(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return true;
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public void setPackaging(String packaging) {
    }

    @Override
    public String getContentType() {
        return "application/atom+xml;type=feed";
    }

    @Override
    public String getPackaging() {
        return null;
    }
}

