/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.TempFileInputStream;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class SimpleZipContentDisseminator
implements SwordContentDisseminator {
    @Override
    public InputStream disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        try {
            Bundle[] originals;
            String tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir");
            String fn = tempDir + File.separator + "SWORD." + item.getID() + "." + UUID.randomUUID().toString() + ".zip";
            FileOutputStream outStream = new FileOutputStream(new File(fn));
            ZipOutputStream zip = new ZipOutputStream(outStream);
            for (Bundle original : originals = item.getBundles("ORIGINAL")) {
                Bitstream[] bss;
                for (Bitstream bitstream : bss = original.getBitstreams()) {
                    ZipEntry ze = new ZipEntry(bitstream.getName());
                    zip.putNextEntry(ze);
                    InputStream is = bitstream.retrieve();
                    Utils.copy((InputStream)is, (OutputStream)zip);
                    zip.closeEntry();
                    is.close();
                }
            }
            zip.close();
            return new TempFileInputStream(new File(fn));
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException(e);
        }
    }

    @Override
    public boolean disseminatesContentType(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return "application/zip".equals(contentType);
    }

    @Override
    public boolean disseminatesPackage(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return UriRegistry.PACKAGE_SIMPLE_ZIP.equals(contentType);
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public void setPackaging(String packaging) {
    }

    @Override
    public String getContentType() {
        return "application/zip";
    }

    @Override
    public String getPackaging() {
        return UriRegistry.PACKAGE_SIMPLE_ZIP;
    }
}

