/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.AtomCollectionGenerator;
import org.dspace.sword2.CommunityCollectionGenerator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordCollection;

public class CollectionCollectionGenerator
implements AtomCollectionGenerator {
    private static Logger log = Logger.getLogger(CommunityCollectionGenerator.class);

    @Override
    public SwordCollection buildCollection(Context context, DSpaceObject dso, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException {
        if (!(dso instanceof Collection)) {
            log.error((Object)"buildCollection passed argument which is not of type Collection");
            throw new DSpaceSwordException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SwordUrlManager urlManager = swordConfig.getUrlManager(context, swordConfig);
        Collection col = (Collection)dso;
        SwordCollection scol = new SwordCollection();
        String location = urlManager.getDepositLocation(col);
        String title = col.getMetadata("name");
        String collectionPolicy = col.getLicense();
        String dcAbstract = col.getMetadata("short_description");
        boolean mediation = swordConfig.isMediated();
        scol.setLocation(location);
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if (collectionPolicy != null && !"".equals(collectionPolicy)) {
            scol.setCollectionPolicy(collectionPolicy);
        }
        if (dcAbstract != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(mediation);
        List<String> accepts = swordConfig.getCollectionAccepts();
        for (String accept : accepts) {
            scol.addAccepts(accept);
            scol.addMultipartAccepts(accept);
        }
        List<String> aps = swordConfig.getAcceptPackaging(col);
        for (String ap : aps) {
            scol.addAcceptPackaging(ap);
        }
        boolean itemService = ConfigurationManager.getBooleanProperty((String)"sword.expose-items");
        if (itemService) {
            String subService = urlManager.constructSubServiceUrl(col);
            scol.addSubService(new IRI(subService));
        }
        log.debug((Object)"Created ATOM Collection for DSpace Collection");
        return scol;
    }
}

