/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.ReceiptGenerator;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordEntryIngester;
import org.dspace.sword2.SwordIngesterFactory;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.VerboseDescription;
import org.dspace.sword2.WorkflowManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.CollectionDepositManager;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class CollectionDepositManagerDSpace
extends DSpaceSwordAPI
implements CollectionDepositManager {
    private static Logger log = Logger.getLogger(CollectionDepositManagerDSpace.class);
    private VerboseDescription verboseDescription = new VerboseDescription();

    @Override
    public DepositReceipt createNew(String collectionUri, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose deposit");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Collection collection;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_create_new", (String)""));
            }
            if ((collection = this.getDepositTarget(context, collectionUri, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.createResource(context, collection);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)collection, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"deposit_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot submit to the given collection with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = null;
            try {
                if (deposit.isBinaryOnly()) {
                    result = this.createNewFromBinary(sc, collection, deposit, authCredentials, config);
                } else if (deposit.isEntryOnly()) {
                    result = this.createNewFromEntry(sc, collection, deposit, authCredentials, config);
                } else if (deposit.isMultipart()) {
                    result = this.createNewFromMultipart(sc, collection, deposit, authCredentials, config);
                }
            }
            catch (DSpaceSwordException e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        if (deposit.isBinaryOnly()) {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        } else if (deposit.isEntryOnly()) {
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        } else if (deposit.isMultipart()) {
                            this.storePackageAsFile(deposit, authCredentials, config);
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + e));
                    }
                }
                throw e;
            }
            catch (SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        if (deposit.isBinaryOnly()) {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        } else if (deposit.isEntryOnly()) {
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        } else if (deposit.isMultipart()) {
                            this.storePackageAsFile(deposit, authCredentials, config);
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + e));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, result, this.verboseDescription);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, result, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    protected DepositResult createNewFromBinary(SwordContext swordContext, Collection collection, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)collection);
        SwordContentIngester si = SwordIngesterFactory.getContentInstance(context, deposit, (DSpaceObject)collection);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription);
        this.verboseDescription.append("Archive ingest completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    protected DepositResult createNewFromEntry(SwordContext swordContext, Collection collection, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        SwordEntryIngester si = SwordIngesterFactory.getEntryInstance(context, deposit, (DSpaceObject)collection);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription);
        this.verboseDescription.append("Archive ingest completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    protected DepositResult createNewFromMultipart(SwordContext swordContext, Collection collection, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        DepositResult result;
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)collection);
        SwordContentIngester sci = SwordIngesterFactory.getContentInstance(context, deposit, (DSpaceObject)collection);
        this.verboseDescription.append("Loaded content ingester: " + sci.getClass().getName());
        SwordEntryIngester sei = SwordIngesterFactory.getEntryInstance(context, deposit, (DSpaceObject)collection);
        this.verboseDescription.append("Loaded entry ingester: " + sei.getClass().getName());
        if (swordConfig.isEntryFirst()) {
            result = sei.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription);
            result = sci.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription, result);
            this.verboseDescription.append("Archive ingest completed successfully");
        } else {
            result = sci.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription);
            result = sei.ingest(context, deposit, (DSpaceObject)collection, this.verboseDescription, result, false);
            this.verboseDescription.append("Archive ingest completed successfully");
        }
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    protected Collection getDepositTarget(Context context, String depositUrl, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        Collection collection = urlManager.getCollection(context, depositUrl);
        if (collection == null) {
            throw new SwordError(404);
        }
        this.verboseDescription.append("Performing deposit using deposit URL: " + depositUrl);
        this.verboseDescription.append("Location resolves to collection with handle: " + collection.getHandle() + " and name: " + collection.getMetadata("name"));
        return collection;
    }
}

