/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSimpleDC;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordEntryIngester;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordEntry;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class SimpleDCEntryIngester
extends AbstractSimpleDC
implements SwordEntryIngester {
    public SimpleDCEntryIngester() {
        this.loadMetadataMaps();
    }

    @Override
    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        return this.ingest(context, deposit, dso, verboseDescription, null, false);
    }

    @Override
    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription, DepositResult result, boolean replace) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        if (dso instanceof Collection) {
            return this.ingestToCollection(context, deposit, (Collection)dso, verboseDescription, result);
        }
        if (dso instanceof Item) {
            return this.ingestToItem(context, deposit, (Item)dso, verboseDescription, result, replace);
        }
        return null;
    }

    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result, boolean replace) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            if (replace) {
                this.removeMetadata(item);
            }
            this.addMetadataToItem(deposit, item);
            this.setUpdatedDate(item, verboseDescription);
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            item.update();
            context.setIgnoreAuthorization(ignore);
            verboseDescription.append("Update successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            return result;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void removeMetadata(Item item) throws DSpaceSwordException {
        String[] parts;
        String raw = ConfigurationManager.getProperty((String)"swordv2-server", (String)"metadata.replaceable");
        for (String part : parts = raw.split(",")) {
            DCValue dcv = this.makeDCValue(part.trim(), null);
            item.clearMetadata(dcv.schema, dcv.element, dcv.qualifier, "*");
        }
    }

    private void addUniqueMetadata(DCValue dcv, Item item) {
        DCValue[] existing;
        String qual = dcv.qualifier;
        if (dcv.qualifier == null) {
            qual = "*";
        }
        String lang = dcv.language;
        if (dcv.language == null) {
            lang = "*";
        }
        for (DCValue dcValue : existing = item.getMetadata(dcv.schema, dcv.element, qual, lang)) {
            if (!dcValue.value.equals(dcv.value)) continue;
            return;
        }
        item.addMetadata(dcv.schema, dcv.element, dcv.qualifier, dcv.language, dcv.value);
    }

    private void addMetadataToItem(Deposit deposit, Item item) throws DSpaceSwordException {
        String abstractField;
        DCValue dcv;
        String titleField;
        SwordEntry se = deposit.getSwordEntry();
        String title = se.getTitle();
        String summary = se.getSummary();
        if (title != null && (titleField = (String)this.dcMap.get("title")) != null) {
            dcv = this.makeDCValue(titleField, title);
            this.addUniqueMetadata(dcv, item);
        }
        if (summary != null && (abstractField = (String)this.dcMap.get("abstract")) != null) {
            dcv = this.makeDCValue(abstractField, summary);
            this.addUniqueMetadata(dcv, item);
        }
        Map<String, List<String>> dc = se.getDublinCore();
        for (String term : dc.keySet()) {
            String dsTerm = (String)this.dcMap.get(term);
            if (dsTerm == null) continue;
            DCValue dcv2 = this.makeDCValue(dsTerm, null);
            Iterator<String> i$ = dc.get(term).iterator();
            while (i$.hasNext()) {
                String value;
                dcv2.value = value = i$.next();
                this.addUniqueMetadata(dcv2, item);
            }
        }
    }

    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = WorkspaceItem.create((Context)context, (Collection)collection, (boolean)true);
                item = wsi.getItem();
            }
            this.addMetadataToItem(deposit, item);
            this.setUpdatedDate(item, verboseDescription);
            this.setSlug(item, deposit.getSlug(), verboseDescription);
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            item.update();
            context.setIgnoreAuthorization(ignore);
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException(e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public DCValue makeDCValue(String field, String value) throws DSpaceSwordException {
        DCValue dcv = new DCValue();
        String[] bits = field.split("\\.");
        if (bits.length < 2 || bits.length > 3) {
            throw new DSpaceSwordException("invalid DC value: " + field);
        }
        dcv.schema = bits[0];
        dcv.element = bits[1];
        if (bits.length == 3) {
            dcv.qualifier = bits[2];
        }
        dcv.value = value;
        return dcv;
    }

    protected void setUpdatedDate(Item item, VerboseDescription verboseDescription) throws DSpaceSwordException {
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        DCValue dc = this.makeDCValue(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        DCDate date = new DCDate(new Date());
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, date.toString());
        verboseDescription.append("Updated date added to response from item metadata where available");
    }

    protected void setSlug(Item item, String slugVal, VerboseDescription verboseDescription) throws DSpaceSwordException {
        if (slugVal == null) {
            return;
        }
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        DCValue dc = this.makeDCValue(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, slugVal);
        verboseDescription.append("Slug value set in response where available");
    }

    private String getTreatment() throws DSpaceSwordException {
        return "A metadata only item has been created";
    }
}

