/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordStatementDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Statement;
import org.swordapp.server.StatementManager;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class StatementManagerDSpace
extends DSpaceSwordAPI
implements StatementManager {
    private static Logger log = Logger.getLogger(StatementManagerDSpace.class);

    @Override
    public Statement getStatement(String stateIRI, Map<String, String> accept, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordServerException, SwordError, SwordAuthException {
        SwordContext sc = null;
        try {
            Statement statement;
            SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
            SwordAuthenticator auth = new SwordAuthenticator();
            sc = auth.authenticate(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_get_statement", (String)""));
            }
            String un = authCredentials.getUsername() != null ? authCredentials.getUsername() : "NONE";
            String obo = authCredentials.getOnBehalfOf() != null ? authCredentials.getOnBehalfOf() : "NONE";
            log.info((Object)LogManager.getHeader((Context)context, (String)"sword_get_statement", (String)("username=" + un + ",on_behalf_of=" + obo)));
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            Item item = urlManager.getItem(context, stateIRI);
            if (item == null) {
                throw new SwordError(404);
            }
            AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)0);
            WorkflowManagerFactory.getInstance().retrieveStatement(context, item);
            String suffix = urlManager.getTypeSuffix(context, stateIRI);
            SwordStatementDisseminator disseminator = null;
            if (suffix != null) {
                HashMap<Float, List<String>> analysed = new HashMap<Float, List<String>>();
                ArrayList<String> list = new ArrayList<String>();
                list.add(suffix);
                analysed.put(Float.valueOf(1.0f), list);
                disseminator = SwordDisseminatorFactory.getStatementInstance(analysed);
            } else {
                String acceptContentType = this.getHeader(accept, "Accept", null);
                TreeMap<Float, List<String>> analysed = this.analyseAccept(acceptContentType);
                disseminator = SwordDisseminatorFactory.getStatementInstance(analysed);
            }
            Statement statement2 = statement = disseminator.disseminate(context, item);
            return statement2;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException();
        }
        catch (SQLException e) {
            throw new SwordServerException(e);
        }
        catch (DSpaceSwordException e) {
            throw new SwordServerException(e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }
}

