/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import org.swordapp.server.OriginalDeposit;
import org.swordapp.server.ResourcePart;
import org.swordapp.server.Statement;
import org.swordapp.server.UriRegistry;

public class OREStatement
extends Statement {
    private String remUri;
    private String aggUri;

    public OREStatement(String remUri, String aggUri) {
        this.remUri = remUri;
        this.aggUri = aggUri;
        this.contentType = "application/rdf+xml";
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix(UriRegistry.ORE_PREFIX, UriRegistry.ORE_NAMESPACE);
        model.setNsPrefix(UriRegistry.SWORD_PREFIX, UriRegistry.SWORD_TERMS_NAMESPACE);
        Resource rem = model.createResource(this.remUri);
        rem.addProperty(RDF.type, (RDFNode)model.createResource(UriRegistry.ORE_NAMESPACE + "ResourceMap"));
        Resource agg = model.createResource(this.aggUri);
        agg.addProperty(RDF.type, (RDFNode)model.createResource(UriRegistry.ORE_NAMESPACE + "Aggregation"));
        rem.addProperty(model.createProperty(UriRegistry.ORE_NAMESPACE + "describes"), (RDFNode)agg);
        agg.addProperty(model.createProperty(UriRegistry.ORE_NAMESPACE + "isDescribedBy"), (RDFNode)rem);
        for (ResourcePart rp : this.resources) {
            Resource part = model.createResource(rp.getUri());
            part.addProperty(RDF.type, (RDFNode)model.createResource(UriRegistry.ORE_NAMESPACE + "AggregatedResource"));
            agg.addProperty(model.createProperty(UriRegistry.ORE_NAMESPACE + "aggregates"), (RDFNode)part);
        }
        for (OriginalDeposit od : this.originalDeposits) {
            Resource deposit = model.createResource(od.getUri());
            deposit.addProperty(RDF.type, (RDFNode)model.createResource(UriRegistry.ORE_NAMESPACE + "AggregatedResource"));
            if (od.getDepositedBy() != null) {
                deposit.addLiteral(model.createProperty(UriRegistry.SWORD_DEPOSITED_BY), (Object)od.getDepositedBy());
            }
            if (od.getDepositedOnBehalfOf() != null) {
                deposit.addLiteral(model.createProperty(UriRegistry.SWORD_DEPOSITED_ON_BEHALF_OF), (Object)od.getDepositedOnBehalfOf());
            }
            if (od.getDepositedOn() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                deposit.addLiteral(model.createProperty(UriRegistry.SWORD_DEPOSITED_ON), (Object)sdf.format(od.getDepositedOn()));
            }
            for (String packaging : od.getPackaging()) {
                deposit.addLiteral(model.createProperty(UriRegistry.SWORD_PACKAGING.toString()), (Object)packaging);
            }
            agg.addProperty(model.createProperty(UriRegistry.ORE_NAMESPACE + "aggregates"), (RDFNode)deposit);
            agg.addProperty(model.createProperty(UriRegistry.SWORD_ORIGINAL_DEPOSIT), (RDFNode)deposit);
        }
        for (String state : this.states.keySet()) {
            Resource s = model.createResource(state);
            if (this.states.get(state) != null) {
                s.addProperty(model.createProperty(UriRegistry.SWORD_STATE_DESCRIPTION), (String)this.states.get(state));
            }
            agg.addProperty(model.createProperty(UriRegistry.SWORD_STATE), (RDFNode)s);
        }
        model.write(out, "RDF/XML");
    }
}

