/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.administrative.FlowCurationUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.SAXException;

public class CurateForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = CurateForm.message("xmlui.general.dspace_home");
    private static final Message T_submit_perform = CurateForm.message("xmlui.general.perform");
    private static final Message T_submit_queue = CurateForm.message("xmlui.general.queue");
    private static final Message T_title = CurateForm.message("xmlui.administrative.CurateForm.title");
    private static final Message T_trail = CurateForm.message("xmlui.administrative.CurateForm.trail");
    private static final Message T_task_label_name = CurateForm.message("xmlui.administrative.CurateForm.task_label_name");
    private static final Message T_taskgroup_label_name = CurateForm.message("xmlui.administrative.CurateForm.taskgroup_label_name");
    private static final Message T_object_label_name = CurateForm.message("xmlui.administrative.CurateForm.object_label_name");
    private static final Message T_object_hint = CurateForm.message("xmlui.administrative.CurateForm.object_hint");

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        FlowCurationUtils.setupCurationTasks();
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException, UnsupportedEncodingException {
        String objectID = this.parameters.getParameter("identifier", null);
        String taskSelected = this.parameters.getParameter("curate_task", null);
        Division div = body.addInteractiveDivision("curate", this.contextPath + "/admin/curate", "multipart", "primary administrative curate");
        div.setHead(T_title);
        List form = div.addList("curate-form", "form");
        Text id = form.addItem().addText("identifier");
        id.setAutofocus("autofocus");
        id.setLabel(T_object_label_name);
        if (objectID != null) {
            id.setValue(objectID);
        }
        id.setRequired();
        id.setHelp(T_object_hint);
        String curateGroup = "";
        try {
            curateGroup = this.parameters.getParameter("select_curate_group") != null ? this.parameters.getParameter("select_curate_group") : "ungrouped";
        }
        catch (Exception pe) {
            // empty catch block
        }
        if (!FlowCurationUtils.groups.isEmpty()) {
            Select groupSelect = form.addItem().addSelect("select_curate_group");
            groupSelect = FlowCurationUtils.getGroupSelectOptions(groupSelect);
            groupSelect.setLabel(T_taskgroup_label_name);
            groupSelect.setSize(1);
            groupSelect.setRequired();
            groupSelect.setEvtBehavior("submitOnChange");
            if (curateGroup.equals("")) {
                curateGroup = FlowCurationUtils.groups.keySet().iterator().next();
            }
            groupSelect.setOptionSelected(curateGroup);
        }
        Select taskSelect = form.addItem().addSelect("curate_task");
        taskSelect = FlowCurationUtils.getTaskSelectOptions(taskSelect, curateGroup);
        taskSelect.setLabel(T_task_label_name);
        taskSelect.setSize(1);
        taskSelect.setRequired();
        if (taskSelected != null) {
            taskSelect.setOptionSelected(taskSelected);
        }
        Para buttonList = div.addPara();
        buttonList.addButton("submit_curate_task").setValue(T_submit_perform);
        buttonList.addButton("submit_queue_task").setValue(T_submit_queue);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

