/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.core.Context;

public class CreateCommunityForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = CreateCommunityForm.message("xmlui.general.dspace_home");
    private static final Message T_title = CreateCommunityForm.message("xmlui.administrative.community.CreateCommunityForm.title");
    private static final Message T_trail = CreateCommunityForm.message("xmlui.administrative.community.CreateCommunityForm.trail");
    private static final Message T_main_head_sub = CreateCommunityForm.message("xmlui.administrative.community.CreateCommunityForm.main_head_sub");
    private static final Message T_main_head_top = CreateCommunityForm.message("xmlui.administrative.community.CreateCommunityForm.main_head_top");
    private static final Message T_label_name = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_name");
    private static final Message T_label_short_description = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_short_description");
    private static final Message T_label_introductory_text = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_introductory_text");
    private static final Message T_label_copyright_text = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_copyright_text");
    private static final Message T_label_side_bar_text = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_side_bar_text");
    private static final Message T_label_logo = CreateCommunityForm.message("xmlui.administrative.community.EditCommunityMetadataForm.label_logo");
    private static final Message T_submit_save = CreateCommunityForm.message("xmlui.administrative.community.CreateCommunityForm.submit_save");
    private static final Message T_submit_cancel = CreateCommunityForm.message("xmlui.general.cancel");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int communityID = this.parameters.getParameterAsInteger("communityID", -1);
        Community parentCommunity = Community.find((Context)this.context, (int)communityID);
        Division main = body.addInteractiveDivision("create-community", this.contextPath + "/admin/community", "multipart", "primary administrative community");
        if (parentCommunity != null) {
            main.setHead(T_main_head_sub.parameterize(parentCommunity.getMetadata("name")));
        } else {
            main.setHead(T_main_head_top);
        }
        List metadataList = main.addList("metadataList", "form");
        metadataList.addLabel(T_label_name);
        Text name = metadataList.addItem().addText("name");
        name.setSize(40);
        name.setAutofocus("autofocus");
        metadataList.addLabel(T_label_short_description);
        Text short_description = metadataList.addItem().addText("short_description");
        short_description.setSize(40);
        metadataList.addLabel(T_label_introductory_text);
        TextArea introductory_text = metadataList.addItem().addTextArea("introductory_text");
        introductory_text.setSize(6, 40);
        metadataList.addLabel(T_label_copyright_text);
        TextArea copyright_text = metadataList.addItem().addTextArea("copyright_text");
        copyright_text.setSize(6, 40);
        metadataList.addLabel(T_label_side_bar_text);
        TextArea side_bar_text = metadataList.addItem().addTextArea("side_bar_text");
        side_bar_text.setSize(6, 40);
        metadataList.addLabel(T_label_logo);
        metadataList.addItem().addFile("logo");
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_save);
        buttonList.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

